# Code for comparing two policies with data, estimates, and optimal policy levels (schools of size between 4 and 50)
# Budget corresponding to the average (optimal) transportation subsidy level
# Subsidy scheme: subsidy proportional to the number of pairs  

# Import packages
import os, sys
import numpy as np
import pandas as pd
import pickle, math
import random 
import scipy.optimize
from scipy.optimize import NonlinearConstraint

# Define, under the social-interaction subsidy, the welfare minus total subsidy buget objective function
def welfare_subsidy_p1(sigm,DIJ,Thetaij,th,T):
    N=DIJ.shape[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N0=(np.ones((N,N))-np.identity(N))*beta0
    DI=np.identity(N)-(alpha/N)*(N0+Thetaij)
    if np.amax(np.linalg.eig(DI)[0])>alpha/N:
        s=np.matmul( np.linalg.inv(DI), (1+alpha*sigm)*np.ones((N,1))-(c*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
        nij=beta0*(np.ones((N,N))-np.identity(N))+(sigm*(np.ones((N,N))-np.identity(N))-c*DIJ)/np.outer(np.ones((N,1)),s)+Thetaij
        F=((sigm*np.matmul(np.matmul(np.ones((1,N)),nij),np.ones((N,1)))-T)**2)[0,0]
    else:
        F=np.inf
    return F    

# Define the total welfare function under the social-interaction subsidy
def totalwelfare_subsidy_p1(sigm,DIJ,Thetaij,th):
    N=DIJ.shape[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N0=(np.ones((N,N))-np.identity(N))*beta0
    DI=np.identity(N)-(alpha/N)*(N0+Thetaij)
    s=np.matmul( np.linalg.inv(DI), (1+alpha*sigm)*np.ones((N,1))-(c*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
    nij=beta0*(np.ones((N,N))-np.identity(N))+(sigm*(np.ones((N,N))-np.identity(N))-c*DIJ)/np.outer(np.ones((N,1)),s)+Thetaij
    F=np.sum(np.sum( (((beta0+Thetaij)*nij-nij*nij/2) * np.outer(np.ones((N,1)),s)) -c*nij*DIJ +sigm*nij))
    return F

# Define, under the transportation subsidy, the welfare minus total subsidy buget objective function
def welfare_subsidy_p2(tau,DIJ,Thetaij,th,T):
    N=DIJ.shape[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N0=(np.ones((N,N))-np.identity(N))*beta0
    DI=np.identity(N)-(alpha/N)*(N0+Thetaij)
    if np.amax(np.linalg.eig(DI)[0])>alpha/N:
        s=np.matmul( np.linalg.inv(DI), np.ones((N,1))-(c*alpha*(1-tau)/N)*np.matmul(DIJ,np.ones((N,1))))
        nij=beta0*(np.ones((N,N))-np.identity(N))-(c*(1-tau)*DIJ)/np.outer(np.ones((N,1)),s)+Thetaij
        F=((tau*np.matmul(np.matmul(np.ones((1,N)),nij*DIJ),np.ones((N,1)))-T)**2)[0,0]
    else:
        F=np.inf
    return F

# Define the total welfare function under the transportation subsidy
def totalwelfare_subsidy_p2(tau,DIJ,Thetaij,th):
    N=DIJ.shape[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    N0=(np.ones((N,N))-np.identity(N))*beta0
    DI=np.identity(N)-(alpha/N)*(N0+Thetaij)
    s=np.matmul( np.linalg.inv(DI), np.ones((N,1))-(c*(1-tau)*alpha/N)*np.matmul(DIJ,np.ones((N,1))))
    nij=beta0*(np.ones((N,N))-np.identity(N))-c*(1-tau)*DIJ/np.outer(np.ones((N,1)),s)+Thetaij
    F=np.sum(np.sum( (((beta0+Thetaij)*nij-nij*nij/2) * np.outer(np.ones((N,1)),s)) -(1-tau)*c*nij*DIJ ))
    return F

if __name__ == '__main__':

    # Load the data
    with open('spatial_interaction_finaldata_schools4to50.pkl','rb') as f:
        Data=pickle.load(f)
    with open('Xdata_pair_level_Schools4to50.pkl','rb') as f:
        xdata=pickle.load(f)
    with open('II_Results_Schools4to50.pkl','rb') as f:
        Result=pickle.load(f)
    th=Result[0]
    beta=th[1:23]
    alpha=th[23:24]
    c=abs(th[24:25])
    beta0=th[0:1]
    sig=th[25:26] 
    Scell=Data[0]
    SDcell=Data[1]
    Xcell1=Data[2]
    Xcell2=Data[3]
    D=Data[4]
    EPcell=Data[5]
    st_list=Data[6]
    GE=Data[7]
    ADcell=Data[9]
    H=len(Scell) 
    Xcell=[] 
    k1=Xcell1[0].shape[2] 
    for h in range(1,H+1):
        Xcell.append(abs(Xcell1[h-1]))
    R=100 
    K=k1*2 
    with open('Pol_to_opt_results_schools4to50.pkl','rb') as f:
        Result_stats=pickle.load(f)
    Nstat001=Result_stats[0]
    Nstat002=Result_stats[1]
    Dstat=Result_stats[2]
    #SIG=Result_stats[3] # Not used in simulations using the B_tau subsidy
    TAU=Result_stats[4] # Not used in simulations using the B_sig subsidy

    # Calculating the total amount of budget 
    NP=np.zeros(H)
    Nstud=np.zeros(H)
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        NP[h-1]=N*(N-1)
        Nstud[h-1]=N
    NPair=np.sum(NP)
    Nst=np.sum(Nstud)
    #B_SIG=np.mean(np.mean(Nstat001,axis=0))*np.mean(np.mean(SIG,axis=0))*NPair # Not used in simulations using the B_tau subsidy
    B_TAU=np.mean(np.mean(Nstat002,axis=0))*c*np.mean(np.mean(TAU,axis=0))*np.mean(Dstat)*NPair # Not used in simulations using the B_sig subsidy

    XBc=[]
    for h in range(1,H+1):
        DIJ=D[h-1]
        N=DIJ.shape[0]
        Xarray1=np.zeros((N,N,K))
        Xarray2=np.zeros((N,N,K))
        X1=Xcell1[h-1]
        X2=Xcell2[h-1]
        for k in range(1,k1+1):
            Xarray1[:,:,k-1]=X1[:,:,k-1]*beta[k-1]
            Xarray2[:,:,k-1]=X2[:,:,k-1]*beta[k1+k-1]
        XBc.append(np.sum(Xarray1,axis=2)+np.sum(Xarray2,axis=2)+(np.ones((N,N))-np.identity(N))*beta0)

    # Start finding two policy levels under the same budget
    SIG=np.zeros((H,R))
    TAU=np.zeros((H,R))
    TW1=np.zeros((H,R))
    TW2=np.zeros((H,R))
    bnds=np.zeros((1,2))
    bnds[0,1]=np.inf
    x1=np.array([0.1])
    bnds2=np.zeros((1,2))
    bnds2[0,1]=1
    for r in range(1,R+1):
        for h in range(1,H+1):
            np.random.seed(1000*r+h)
            DIJ=D[h-1]
            N=DIJ.shape[0]
            ERR=sig*np.random.standard_normal((N,N))
            Thetaij=XBc[h-1]+ERR-(np.ones((N,N))-np.identity(N))*beta0
            XBij=XBc[h-1] 
            A=SDcell[h-1]
            F=ADcell[h-1]
            T=B_TAU*N*(N-1)/NPair
            x1=0.1
            sub1min=scipy.optimize.minimize(welfare_subsidy_p1,x1,args=(DIJ,Thetaij,th,T),bounds=bnds)
            sub2min=scipy.optimize.minimize(welfare_subsidy_p2,x1,args=(DIJ,Thetaij,th,T),bounds=bnds2)
            SIG[h-1,r-1]=sub1min.x
            TAU[h-1,r-1]=sub2min.x
            TW1[h-1,r-1]=totalwelfare_subsidy_p1(sub1min.x,DIJ,Thetaij,th)
            TW2[h-1,r-1]=totalwelfare_subsidy_p2(sub2min.x,DIJ,Thetaij,th)

    # Find the number of networks with higher welfare for each policy
    SUB1WIN_TOT=np.sum((TW1>TW2)*1,axis=0)
    SUB2WIN_TOT=np.sum((TW2>TW1)*1,axis=0)
    # Find the difference in the average welfare between two subsidies
    Nsch=np.zeros(H)
    for r in range(1,R+1):
        for h in range(1,H+1):
            DIJ=D[h-1]
            N=DIJ.shape[0]
            Nsch[h-1]=N
    ATW1=np.sum(TW1,axis=0)/np.sum(Nsch)
    ATW2=np.sum(TW2,axis=0)/np.sum(Nsch)

    # Collect results
    TB=np.zeros((3,3))
    TB[0,0]=np.median(SUB1WIN_TOT)
    SUB1WIN_TOT.sort()
    TB[0,1]=SUB1WIN_TOT[5]
    TB[0,2]=SUB1WIN_TOT[94]
    TB[1,0]=np.median(SUB2WIN_TOT)
    SUB2WIN_TOT.sort()
    TB[1,1]=SUB2WIN_TOT[5]
    TB[1,2]=SUB2WIN_TOT[94]
    TB[2,0]=np.mean(ATW1-ATW2)
    TB[2,1]=np.quantile(ATW1-ATW2,0.05)
    TB[2,2]=np.quantile(ATW1-ATW2,0.95)

    # Store results
    with open('TAB_Comp_Pol_pairsub_Btau_schools4to50.pkl','wb') as f:
        pickle.dump(TB,f)
    Result=[SIG,TAU,TW1,TW2,SUB1WIN_TOT,SUB2WIN_TOT,ATW1,ATW2]
    with open('Comp_Pol_pairsub_Btau_schools4to50.pkl','wb') as f:
        pickle.dump(Result,f)
